# 2025-08-25 Triage Log

Lot of regressions this week, mostly in rustdoc benchmarks from newly added features. The rest of the suite saw mostly small regressions in small benchmarks and also some improvements, notably from token tree parsing optimization in macro code, span optimization and ongoing work on new solver, which is not fully enabled, yet.

Triage done by **@panstromek**.
Revision range: [239e8b1b..ee361e8f](https://perf.rust-lang.org/?start=239e8b1b47b34120287ec36b33228c1e177f0c38&end=ee361e8fca1c30e13e7a31cc82b64c045339d3a8&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 3.7%  | [0.3%, 34.5%]  | 42    |
| Regressions ❌ <br /> (secondary)  | 2.3%  | [0.0%, 53.3%]  | 79    |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.7%, -0.3%] | 9     |
| Improvements ✅ <br /> (secondary) | -0.9% | [-2.8%, -0.0%] | 30    |
| All ❌✅ (primary)                 | 3.0%  | [-0.7%, 34.5%] | 51    |


5 Regressions, 1 Improvement, 7 Mixed; 6 of them in rollups
38 artifact comparisons made in total

#### Regressions

Rollup of 19 pull requests [#145589](https://github.com/rust-lang/rust/pull/145589) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b96868fa2ef174b0a5aeb3bf041b3a5b517f11f8&end=8365fcb2b840c95eeb0bc377af8bd498fad22245&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 6.2%  | [0.2%, 33.1%]  | 18    |
| Regressions ❌ <br /> (secondary)  | 3.4%  | [0.3%, 50.8%]  | 24    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.0% | [-0.0%, -0.0%] | 1     |
| All ❌✅ (primary)                 | 6.2%  | [0.2%, 33.1%]  | 18    |

`doc` regressions were expected, but not as big. Pinged @zalathar, who investigated some of the regressions.

Rollup of 15 pull requests [#145600](https://github.com/rust-lang/rust/pull/145600) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=16ad385579cebb6f7d53367c552661b6b51a4a02&end=05f5a58e84a9c3a68586d70bf3d7442c571e379e&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 4.6% | [4.6%, 4.6%] | 1     |
| Regressions ❌ <br /> (secondary)  | 4.4% | [4.4%, 4.4%] | 1     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 4.6% | [4.6%, 4.6%] | 1     |

Looks like noise, syn is just coming back from a spike from previous rollup.

Split transmute check from HIR typeck [#145469](https://github.com/rust-lang/rust/pull/145469) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6545b056388a727c2ac4a4e70fb01d60a11398b1&end=78b89ebb6b20cf50370335e14c5357a4388ac760&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6% | [0.6%, 0.6%] | 1     |
| Regressions ❌ <br /> (secondary)  | 0.8% | [0.6%, 1.0%] | 6     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.6% | [0.6%, 0.6%] | 1     |

Regression looks real, but small and affect mostly secondary stress test. Asked on the PR whether that's justified. 

Rollup of 28 pull requests [#145773](https://github.com/rust-lang/rust/pull/145773) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=78b89ebb6b20cf50370335e14c5357a4388ac760&end=8df154bffddcb6bbb543ad69aff971795c5adbc2&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5% | [0.5%, 0.5%] | 1     |
| Regressions ❌ <br /> (secondary)  | 2.1% | [0.1%, 4.2%] | 2     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.5% | [0.5%, 0.5%] | 1     |

`include-blob` regression looks like noise (similar bump we occasinaly see on it). Smaller doc regression was identified by @zalathar as [#145731](https://github.com/rust-lang/rust/pull/145731) and is somewhat expected as there's more work to do when generating search index.

Add support for macro expansion in rustdoc source code pages [#137229](https://github.com/rust-lang/rust/pull/137229) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3776358beb5747d938bdefaf47a1c76723e6a372&end=809200ec956983fce4ae178b87dada69f01d0820&stat=instructions:u)

| (instructions:u)                   | mean | range         | count |
|:----------------------------------:|:----:|:-------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.5% | [0.4%, 6.6%]  | 16    |
| Regressions ❌ <br /> (secondary)  | 5.8% | [0.6%, 16.5%] | 10    |
| Improvements ✅ <br /> (primary)   | -    | -             | 0     |
| Improvements ✅ <br /> (secondary) | -    | -             | 0     |
| All ❌✅ (primary)                 | 1.5% | [0.4%, 6.6%]  | 16    |

`doc` regression, triaged by @GuillaumeGomez: "Sadly the perf impact was to be expected since it adds more code." Some performance improvement is likely possible by future improvements based on another commment in the thread.

#### Improvements

Sometimes skip over tokens in `parse_token_tree`. [#145348](https://github.com/rust-lang/rust/pull/145348) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=22a86f8280becb12c34ee3efd952baf5cf086fa0&end=bec747418c9955de4c3fd0aac4acb99206f00aa2&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -1.0% | [-2.1%, -0.3%] | 16    |
| All ❌✅ (primary)                 | -     | -              | 0     |


#### Mixed

Update cargo [#145478](https://github.com/rust-lang/rust/pull/145478) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=239e8b1b47b34120287ec36b33228c1e177f0c38&end=aaf87a6d289053246d19f94fbc9972582816e93d&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.1%  | [1.0%, 1.2%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 1.1%  | [1.1%, 1.1%]   | 1     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.4%, -0.3%] | 7     |
| All ❌✅ (primary)                 | 1.1%  | [1.0%, 1.2%]   | 2     |

Regressions in `syn` look like noise, returning to previous state. Cargo update should have no effect on this. Already triaged by Mark.

library: Migrate from `cfg_if` to `cfg_select` [#145489](https://github.com/rust-lang/rust/pull/145489) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=aaf87a6d289053246d19f94fbc9972582816e93d&end=9eb4a2652031ed5ba97c29ef21c79db1645f7883&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.4%]   | 9     |
| Improvements ✅ <br /> (primary)   | -1.2% | [-1.2%, -1.2%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -1.2% | [-1.2%, -1.2%] | 1     |

`include-blob` regersion is noise (bimodality, returning to the default state).

Rollup of 15 pull requests [#145599](https://github.com/rust-lang/rust/pull/145599) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8c32e313cccf7df531e2d49ffb8227bb92304aee&end=16ad385579cebb6f7d53367c552661b6b51a4a02&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.1%, 0.5%]   | 11    |
| Improvements ✅ <br /> (primary)   | -4.8% | [-4.8%, -4.8%] | 1     |
| Improvements ✅ <br /> (secondary) | -4.6% | [-4.6%, -4.6%] | 1     |
| All ❌✅ (primary)                 | -2.3% | [-4.8%, 0.2%]  | 2     |

Non doc results are noise. For `doc` regressions, seems like https://github.com/rust-lang/rust/pull/139345 is the most likely (based on [these results](https://github.com/rust-lang/rust/pull/145599#issuecomment-3208161337)? It seems plausible as it changes FxHashMap to FxIndexMap, which is bigger I believe. I'm inclined to say that it's ok, since that's a correctness change, too and the regressions are small (also seem a bit overshooting and slightly reduced in next PR).

Tell LLVM about read-only captures [#145259](https://github.com/rust-lang/rust/pull/145259) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=040a98af70f0a7da03f3d5356531b28a2a7a77e4&end=125ff8a788c5d6a66917f499abdc00051afe6886&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.8%  | [0.8%, 0.8%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.4%]   | 7     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 1     |
| Improvements ✅ <br /> (secondary) | -1.3% | [-1.7%, -0.2%] | 8     |
| All ❌✅ (primary)                 | 0.3%  | [-0.2%, 0.8%]  | 2     |

`include-blob` regressions are noise. `serde_derive` looks real but it's tiny (adding a println statement). Seems like the biggest query differences are in LLVM, that seems to match the PR area.


Rollup of 16 pull requests [#145728](https://github.com/rust-lang/rust/pull/145728) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6ba0ce40941eee1ca02e9ba49c791ada5158747a&end=8e3710ef31a0b2cdf5a1c2f3929b7735d1e28c20&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.2%, 0.2%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.8% | [-1.2%, -0.4%] | 5     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.8% | [-1.2%, -0.4%] | 5     |

Single regression is in new solver, which is not finished and not enabled by default.

Only unpack span data once to compute end_point and next_point. [#145494](https://github.com/rust-lang/rust/pull/145494) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=46c219bd24862c0a87f0299570bb37f2d5ecf6ce&end=6545b056388a727c2ac4a4e70fb01d60a11398b1&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.7%  | [0.4%, 0.8%]   | 6     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.2%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.6%, -0.4%] | 9     |
| All ❌✅ (primary)                 | -0.3% | [-0.3%, -0.2%] | 2     |

`tt-muncher` regression is noise (bimodality, returning back to previous state)


Rollup of 14 pull requests [#145796](https://github.com/rust-lang/rust/pull/145796) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=69b76df90c7ea63b5350d1865f92902a0b27c9a2&end=f6d23413c399fb530be362ebcf25a4e788e16137&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.8%  | [0.8%, 0.9%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 1.5%  | [1.5%, 1.5%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.4%, -0.3%] | 2     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.2%  | [-0.4%, 0.9%]  | 4     |

`tt-muncher` regression is noise. The other two I'm not sure. They could also be noise because they have symetrical improvements from https://github.com/rust-lang/rust/pull/145728. All of this is in the backend, I don't see anything related in the PR list, so I guess it might be codegen unit shuffling?
