Robot Raconteur Core C++ Library {#mainpage}
==============

![](logo-header.svg)

* **Framework**
  * \ref introduction
    * \ref example_robot
  * \ref service_definition
    * \ref service_definition_names
    * \ref value_types
    * \ref object_types
    * \ref constants
    * \ref robdef_exceptions
    * \ref using
    * \ref conventions
  * \ref nodes_and_communication
    * \ref nodes
      * \ref nodeid
      * \ref messages
        * \ref message_value_types
        * \ref message_object_protocol
      * \ref service_paths
    * \ref transports
    * \ref urls
  * \ref exceptions
  * \ref security
    * \ref security_policy
    * \ref tls_certificates
    * \ref transport_security
  * \ref locking
    * \ref user_locking
    * \ref client_locking
    * \ref monitor_locking
  * \ref ecosystem
    * \ref stdrobdef
    * \ref companion
    * \ref directory

* **C++ Core Library**
  * \ref cpp_introduction
    * \ref cpp_installation
    * \ref cpp_building
    * \ref cpp_ros
    * \ref cpp_intro_cmake_thunk_source_gen
    * \ref cpp_boost_library
    * \ref cpp_smart_pointers
  * \ref robotraconteurgen
  * \ref robotraconteur_generate_thunk
  * \ref cpp_threading_and_async
    * \ref cpp_threading
    * \ref cpp_async
    * \ref cpp_single_thread
  * \ref cpp_value_types
    * \ref cpp_stack_and_pointers
    * \ref cpp_null_pointers
    * \ref cpp_boxing
    * \ref cpp_numeric_types
    * \ref cpp_string_types
    * \ref cpp_structure_types
    * \ref cpp_pod_types
    * \ref cpp_namedarray_types
    * \ref cpp_container_types
    * \ref cpp_varvalue_type
  * \ref cpp_node_setup
    * \ref cpp_client_node_setup
    * \ref cpp_server_node_setup
    * \ref command_line_options
    * \ref cpp_advanced_node_setup
  * \ref cpp_client
    * \ref cpp_client_connections
      * \ref cpp_client_urls
      * \ref cpp_client_auth
      * \ref cpp_client_listener
      * \ref cpp_client_connect_object_type
    * \ref cpp_client_disconnect
    * \ref cpp_client_subscriptions
    * \ref cpp_client_members
      * \ref cpp_client_property
      * \ref cpp_client_function
        * \ref cpp_client_normal_functions
        * \ref cpp_client_generator_functions
        * \ref cpp_client_generators
      * \ref cpp_client_event
      * \ref cpp_client_objref
      * \ref cpp_client_pipe
      * \ref cpp_client_callback
      * \ref cpp_client_wire
      * \ref cpp_client_memory
    * \ref cpp_client_object_locking
      * \ref cpp_client_user_locks
      * \ref cpp_client_client_locks
      * \ref cpp_client_monitor_locks
  * \ref cpp_service
    * \ref cpp_service_server_context
    * \ref cpp_service_server_endpoint
    * \ref cpp_service_service_path
    * \ref cpp_service_implement_objects
      * \ref cpp_service_irrserviceobject_interface
      * \ref cpp_service_property
      * \ref cpp_service_function
        * \ref cpp_service_normal_functions
        * \ref cpp_service_generator_functions
      * \ref cpp_service_event
      * \ref cpp_service_objref
      * \ref cpp_service_pipe
      * \ref cpp_service_callback
      * \ref cpp_service_wire
      * \ref cpp_service_memory
    * \ref cpp_service_security
    * \ref cpp_service_locking
      * \ref cpp_service_locking_user_client
      * \ref cpp_service_locking_monitor
    * \ref cpp_service_attributes
    * \ref cpp_service_release_path
  * \ref cpp_constants
  * \ref cpp_discovery
    * \ref cpp_service_discovery
    * \ref cpp_node_discovery
  * \ref cpp_subscriptions
    * \ref cpp_service_subscription
    * \ref cpp_subscription_filters
    * \ref cpp_subscription_service_type
    * \ref cpp_subscription_serviceinfo2
  * \ref logging
  * \ref taps
* [Class Index](classes.html)
