% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf2sos.R
\name{tf2sos}
\alias{tf2sos}
\title{Transfer function to second-order sections form}
\usage{
tf2sos(b, a)
}
\arguments{
\item{b}{moving average (MA) polynomial coefficients}

\item{a}{autoregressive (AR) polynomial coefficients}
}
\value{
A list with the following list elements:
\describe{
  \item{sos}{Second-order section representation, specified as an nrow-by-6
  matrix, whose rows contain the numerator and denominator coefficients of
  the second-order sections:\cr \code{sos <- rbind(cbind(B1, A1), cbind(...),
  cbind(Bn, An))}, where \code{B1 <- c(b0, b1, b2)}, and \code{A1 <- c(a0,
  a1, a2)} for section 1, etc. The b0 entry must be nonzero for each
  section.}
\item{g}{Overall gain factor that effectively scales the output \code{b}
  vector (or any one of the input \code{Bi} vectors).}
}
}
\description{
Convert digital filter transfer function data to second-order section form.
}
\examples{
b <- c(1, 0, 0, 0, 0, 1)
a <- c(1, 0, 0, 0, 0, .9)
sosg <- tf2sos (b, a)

}
\seealso{
See also \code{\link{filter}}
}
\author{
Julius O. Smith III, \email{jos@ccrma.stanford.edu}.\cr
Conversion to R by Geert van Boxtel, \email{gjmvanboxtel@gmail.com}.
}
