% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_bracket.R
\name{stat_bracket}
\alias{stat_bracket}
\alias{geom_bracket}
\title{Add Brackets with Labels to a GGPlot}
\usage{
stat_bracket(
  mapping = NULL,
  data = NULL,
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  label = NULL,
  type = c("text", "expression"),
  y.position = NULL,
  xmin = NULL,
  xmax = NULL,
  step.increase = 0,
  step.group.by = NULL,
  tip.length = 0.03,
  bracket.nudge.y = 0,
  bracket.shorten = 0,
  size = 0.3,
  linewidth = size,
  label.size = 3.88,
  family = "",
  vjust = 0,
  ...
)

geom_bracket(
  mapping = NULL,
  data = NULL,
  stat = "bracket",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  label = NULL,
  type = c("text", "expression"),
  y.position = NULL,
  xmin = NULL,
  xmax = NULL,
  step.increase = 0,
  step.group.by = NULL,
  tip.length = 0.03,
  bracket.nudge.y = 0,
  bracket.shorten = 0,
  size = 0.3,
  linewidth = size,
  label.size = 3.88,
  family = "",
  vjust = 0,
  coord.flip = FALSE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with a
warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display. To include legend keys for all levels, even
when no data exists, use \code{TRUE}.  If \code{NA}, all levels are shown in legend,
but unobserved levels are omitted.}

\item{inherit.aes}{If \code{FALSE} (the default for most ggpubr functions), 
overrides the default aesthetics, rather than combining with them. This is 
most useful for helper functions that define both data and aesthetics and 
shouldn't inherit behaviour from the default plot specification. Set to 
\code{TRUE} to inherit aesthetics from the parent ggplot layer.}

\item{label}{character vector with alternative label, if not null test is
ignored}

\item{type}{the label type. Can be one of "text" and "expression" (for
parsing plotmath expression).}

\item{y.position}{numeric vector with the y positions of the brackets}

\item{xmin}{numeric vector with the positions of the left sides of the
brackets}

\item{xmax}{numeric vector with the positions of the right sides of the
brackets}

\item{step.increase}{numeric vector with the increase in fraction of total
height for every additional comparison to minimize overlap.}

\item{step.group.by}{a variable name for grouping brackets before adding
step.increase. Useful to group bracket by facet panel.}

\item{tip.length}{numeric vector with the fraction of total height that the
bar goes down to indicate the precise column}

\item{bracket.nudge.y}{Vertical adjustment to nudge brackets by. Useful to
move up or move down the bracket. If positive value, brackets will be moved
up; if negative value, brackets are moved down.}

\item{bracket.shorten}{a small numeric value in [0-1] for shortening the with
of bracket.}

\item{size}{change the width of the lines of the bracket. Deprecated, use \code{linewidth} instead.}

\item{linewidth}{change the width of the lines of the bracket}

\item{label.size}{change the size of the label text}

\item{family}{change the font used for the text}

\item{vjust}{move the text up or down relative to the bracket}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}()}). These are often
aesthetics, used to set an aesthetic to a fixed value, like \code{color =
"red"} or \code{size = 3}. They may also be parameters to the paired
geom/stat.}

\item{stat}{The statistical transformation to use on the data for this layer.
When using a \verb{geom_*()} function to construct a layer, the \code{stat}
argument can be used to override the default coupling between geoms and
stats. The \code{stat} argument accepts the following:
\itemize{
\item A \code{Stat} ggproto subclass, for example \code{StatCount}.
\item A string naming the stat. To give the stat as a string, strip the
function name of the \code{stat_} prefix. For example, to use \code{stat_count()},
give the stat as \code{"count"}.
\item For more information and other ways to specify the stat, see the
\link[ggplot2:layer_stats]{layer stat} documentation.
}}

\item{coord.flip}{logical. If \code{TRUE}, flip x and y coordinates so that
horizontal becomes vertical, and vertical, horizontal. When adding the
p-values to a horizontal ggplot (generated using
\code{\link[ggplot2]{coord_flip}()}), you need to specify the option
\code{coord.flip = TRUE}.}
}
\description{
add brackets with label annotation to a ggplot. Helpers for
  adding p-value or significance levels to a plot.
}
\examples{
df <- ToothGrowth
df$dose <- factor(df$dose)

# Add bracket with labels
ggboxplot(df, x = "dose", y = "len") +
  geom_bracket(
    xmin = "0.5", xmax = "1", y.position = 30,
    label = "t-test, p < 0.05"
  )

# Customize bracket tip.length tip.length
ggboxplot(df, x = "dose", y = "len") +
  geom_bracket(
    xmin = "0.5", xmax = "1", y.position = 30,
    label = "t-test, p < 0.05", tip.length = c(0.2, 0.02)
  )

#Using plotmath expression
ggboxplot(df, x = "dose", y = "len") +
 geom_bracket(
   xmin = "0.5", xmax = "1", y.position = 30,
   label = "list(~italic(p)<=0.001)", type = "expression",
   tip.length = c(0.2, 0.02)
 )

# Specify multiple brackets manually
ggboxplot(df, x = "dose", y = "len") +
  geom_bracket(
    xmin = c("0.5", "1"), xmax = c("1", "2"),
    y.position = c(30, 35), label = c("***", "**"),
    tip.length = 0.01
  )

# Compute statistical tests and add p-values
stat.test <- compare_means(len ~ dose, ToothGrowth, method = "t.test")
ggboxplot(df, x = "dose", y = "len") +
  geom_bracket(
    aes(xmin = group1, xmax = group2, label = signif(p, 2)),
    data = stat.test, y.position = 35
  )

# Increase step length between brackets
ggboxplot(df, x = "dose", y = "len") +
  geom_bracket(
    aes(xmin = group1, xmax = group2, label = signif(p, 2)),
    data = stat.test, y.position = 35, step.increase = 0.1
  )

# Or specify the positions of each comparison
ggboxplot(df, x = "dose", y = "len") +
  geom_bracket(
    aes(xmin = group1, xmax = group2, label = signif(p, 2)),
    data = stat.test, y.position = c(32, 35, 38)
   )
}
