; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=arm-eabi -mattr=+v5t %s -o - | FileCheck %s -check-prefixes=CHECK,INLINE
; RUN: llc -mtriple=arm-eabi %s -o - | FileCheck %s -check-prefixes=CHECK,LIBCALL

declare i32 @llvm.ctlz.i32(i32, i1)

define i32 @undef_zero(i32 %x) {
; INLINE-LABEL: undef_zero:
; INLINE:       @ %bb.0:
; INLINE-NEXT:    clz r0, r0
; INLINE-NEXT:    bx lr
;
; LIBCALL-LABEL: undef_zero:
; LIBCALL:       @ %bb.0:
; LIBCALL-NEXT:    b __clzsi2
        %tmp.1 = call i32 @llvm.ctlz.i32( i32 %x, i1 true )
        ret i32 %tmp.1
}

define i32 @no_undef_zero(i32 %x) {
; INLINE-LABEL: no_undef_zero:
; INLINE:       @ %bb.0:
; INLINE-NEXT:    clz r0, r0
; INLINE-NEXT:    bx lr
;
; LIBCALL-LABEL: no_undef_zero:
; LIBCALL:       @ %bb.0:
; LIBCALL-NEXT:    cmp r0, #0
; LIBCALL-NEXT:    moveq r0, #32
; LIBCALL-NEXT:    moveq pc, lr
; LIBCALL-NEXT:  .LBB1_1: @ %cond.false
; LIBCALL-NEXT:    .save {r11, lr}
; LIBCALL-NEXT:    push {r11, lr}
; LIBCALL-NEXT:    bl __clzsi2
; LIBCALL-NEXT:    pop {r11, lr}
; LIBCALL-NEXT:    mov pc, lr
        %tmp.1 = call i32 @llvm.ctlz.i32( i32 %x, i1 false )
        ret i32 %tmp.1
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK: {{.*}}
